/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.common.IJourneyMapPlugin;
import journeymap.api.v2.common.JourneyMapPlugin;
import journeymap.api.v2.server.IServerAPI;
import journeymap.api.v2.server.IServerPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public final class PluginHelper {
    public static final PluginManager<IClientAPI, IClientPlugin> CLIENT = new PluginManager(IClientPlugin.class, IServerPlugin.class, "Client");
    public static final PluginManager<IServerAPI, IServerPlugin> SERVER = new PluginManager(IServerPlugin.class, IClientPlugin.class, "Server");

    public static class PluginManager<A, P extends IJourneyMapPlugin> {
        private static final Logger LOGGER = LogManager.getLogger((String)"journeymap");
        private final Class<P> pluginInterface;
        private final Class<? extends IJourneyMapPlugin> oppositePluginInterface;
        private final String pluginType;
        private Map<String, P> plugins = null;
        private boolean initialized = false;

        private PluginManager(Class<P> pluginInterface, Class<? extends IJourneyMapPlugin> oppositePluginInterface, String pluginType) {
            this.pluginInterface = pluginInterface;
            this.oppositePluginInterface = oppositePluginInterface;
            this.pluginType = pluginType;
        }

        public Map<String, P> preInit(List<String> pluginClassNames) {
            if (this.plugins != null) {
                LOGGER.warn("{} plugins have already been pre-initialized.", (Object)this.pluginType);
                return this.plugins;
            }
            HashMap<String, IJourneyMapPlugin> discovered = new HashMap<String, IJourneyMapPlugin>();
            LOGGER.info("Scanning for {} plugins...", (Object)this.pluginType);
            for (String className : pluginClassNames) {
                try {
                    Class<?> loadedClass = Class.forName(className);
                    if (this.oppositePluginInterface.isAssignableFrom(loadedClass) || !this.pluginInterface.isAssignableFrom(loadedClass)) continue;
                    Class<P> pluginImplClass = loadedClass.asSubclass(this.pluginInterface);
                    String apiVersion = null;
                    boolean isLegacy = false;
                    if (loadedClass.isAnnotationPresent(JourneyMapPlugin.class)) {
                        apiVersion = loadedClass.getAnnotation(JourneyMapPlugin.class).apiVersion();
                    } else if (this.pluginInterface == IClientPlugin.class && loadedClass.isAnnotationPresent(journeymap.api.v2.client.JourneyMapPlugin.class)) {
                        apiVersion = loadedClass.getAnnotation(journeymap.api.v2.client.JourneyMapPlugin.class).apiVersion();
                        isLegacy = true;
                    }
                    if (apiVersion == null) {
                        LOGGER.error("Found class {}, but it is not annotated with @JourneyMapPlugin. Skipping.", (Object)className);
                        continue;
                    }
                    if (this.inVersionRange(apiVersion)) {
                        IJourneyMapPlugin instance = (IJourneyMapPlugin)pluginImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        String modId = instance.getModId();
                        if (Strings.isNullOrEmpty((String)modId)) {
                            throw new IllegalStateException(String.format("%s.getModId() must return a non-empty, non-null value.", this.pluginInterface.getSimpleName()));
                        }
                        if (discovered.containsKey(modId)) {
                            throw new IllegalStateException(String.format("Duplicate modId '%s' found between %s and %s", modId, className, ((IJourneyMapPlugin)discovered.get(modId)).getClass().getName()));
                        }
                        discovered.put(modId, instance);
                        LOGGER.info("Discovered {} plugin: {} from mod {}", (Object)this.pluginType, (Object)className, (Object)modId);
                        if (!isLegacy) continue;
                        LOGGER.warn("Mod '{}' is using a deprecated @JourneyMapPlugin annotation. Please notify the author to update.", (Object)modId);
                        continue;
                    }
                    LOGGER.error("Found {} plugin {}, but its API version '{}' is not compatible with JourneyMap's required version '{}'. Skipping.", (Object)this.pluginType, (Object)className, (Object)apiVersion, (Object)"2.0.0");
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load {} plugin: {}", (Object)this.pluginType, (Object)className, (Object)e);
                }
            }
            if (discovered.isEmpty()) {
                LOGGER.info("No {} plugins for JourneyMap API discovered.", (Object)this.pluginType);
            }
            this.plugins = Collections.unmodifiableMap(discovered);
            return this.plugins;
        }

        public Map<String, P> init(A api) {
            if (this.plugins == null) {
                LOGGER.warn("Plugin pre-initialization never occurred for {} plugins. Cannot initialize.", (Object)this.pluginType, (Object)new IllegalStateException());
                return Collections.emptyMap();
            }
            if (this.initialized) {
                LOGGER.warn("{} plugins have already been initialized!", (Object)this.pluginType, (Object)new IllegalStateException());
                return this.plugins;
            }
            LOGGER.info("Initializing {} plugins with API: {}", (Object)this.pluginType, (Object)api.getClass().getName());
            HashMap<String, P> initializedPlugins = new HashMap<String, P>(this.plugins);
            Iterator iter = initializedPlugins.values().iterator();
            while (iter.hasNext()) {
                IJourneyMapPlugin plugin = (IJourneyMapPlugin)iter.next();
                try {
                    LOGGER.info("Initialized {} plugin: {}", (Object)this.pluginType, (Object)plugin.getClass().getName());
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to initialize {} plugin: {}", (Object)this.pluginType, (Object)plugin.getClass().getName(), (Object)t);
                    iter.remove();
                }
            }
            this.plugins = Collections.unmodifiableMap(initializedPlugins);
            this.initialized = true;
            return this.plugins;
        }

        private boolean inVersionRange(String pluginApiVersion) {
            return true;
        }

        public Map<String, P> getPlugins() {
            return this.plugins;
        }
    }
}

